//OpenLoop Frequency Response & ClosedLoop Transient Response

// 1) Correlation b/w ub(Normalized bandwidth) & zeta(Damping factor) for a II order system
deff("[wbbywn]=f1(zeta)","wbbywn=sqrt(1-2*zeta^2+sqrt(2-4*zeta^2+4*zeta^4))")
zeta=[0:0.01:0.9];// don't end with 1 bec, division by 0 error
subplot(221)
fplot2d(zeta,f1,[1])
xgrid(3)
xtitle(['Correlation b/w ub(Normalized bandwidth) & zeta for a II order system'],'zeta (Damping ratio)', 'wb / wn' );

// 2) Correlation b/w Mp(Peak overshoot) & Mr(Resonance Peak) for a II order system
deff("[Mp]=f2(zeta)","Mp=exp((-%pi*zeta)/sqrt(1-zeta^2))")
deff("[Mr]=f3(zeta)","Mr=1/(2*zeta*sqrt(1-zeta^2))")
zeta=[0.05:0.01:0.9];  //don't start from 0 & end with 0 because, division by 0 error
subplot(222)
xset("line style",4);
fplot2d(zeta,f2,[1])
xset("line style",1);
fplot2d(zeta,f3,[1])
xgrid(3)
xtitle(['Correlation between Mp & Mr for a II order system'],'zeta (Damping ratio)', 'Mp, Mr' );
legends(['Mp (Peak Gain)';'Mr (Gain at Resonance)'],[[1;4],[1;1]],opt=1);

// 3) Correlation between wr(Resonant frequency) & wd(Damped frequency) for a II order system
deff("[wrbywd]=f4(zeta)","wrbywd=sqrt(1-2*zeta^2)/sqrt(1-zeta^2)")
zeta=[0:0.01:0.9];// don't end with 1 bec, division by 0 error
subplot(223)
fplot2d(zeta,f4,[1])
xgrid(3)
xtitle(['Correlation between wr & wd for a II order system'],'zeta (Damping ratio)', 'wr / wd' );
